#ifdef GL_ES
precision mediump float;

varying vec2 vTexCoord;

vec4 fragColor;
#else
in vec2 vTexCoord;

out vec4 fragColor;
#endif
uniform vec4 inColor;
uniform sampler2D colorTex;

void main()
{
#ifdef GL_ES
    float alpha = texture2D(colorTex, vTexCoord.st).a;
    gl_FragColor = vec4(inColor.rgb, alpha);
#else
    float alpha = texture(colorTex, vTexCoord.st).a;
    fragColor = vec4(inColor.rgb, alpha);
#endif
}
